//
// Triangle class, subclass of Shape
// Triangle.h
//
// Demonstration to show the use of class hierarchies in C++
//
// Donald H. House  Nov. 19, 2019
// CPSC 1070 example code
// Clemson University
//

#ifndef _TRIANGLE_H_
#define _TRIANGLE_H_

#include "Shape.h"
#include <iostream>

//
// Subclass of 2D integer valued points with a text label
//
class Triangle: public Shape{
private:
  EZ_Point verts[3];
  
public:
  Triangle();

  void SetVerts(const EZ_Point v[3]);
  void GetVerts(EZ_Point v[3]) const;
  
  virtual void Draw() const;

  // define << operator as friend function to Triangle
  friend std::ostream& operator<<(std::ostream& os, const Triangle &t);
};

#endif
