//
//  functor.cpp
//  Program demonstrating how a functor class can be used
//  with STL sequence operations. A functor is a function object.
//  A function object implements a function by overloading () and can
//  be parameterized, typically via its constructor.
//
//  Clemson University  CPSC 1070
//  Created by Donald House on 12/3/19.
//

#include <iostream>
#include <vector>
#include <string>
#include <algorithm>
using namespace std;

template<class Type>
class check_in_range{
private:
  Type low, high;
public:
  check_in_range(const Type &lo, const Type &hi): low(lo), high(hi){
  }
  bool operator()(Type val) const {
    return val >= low && val <= high;
  }
};

int main(){
  vector<int> table;
  
  int num;
  cin >> num;
  while(num >= 0){
    table.push_back(num);
    cin >> num;
  }
  
  int inrange = count_if(table.begin(), table.end(), check_in_range<int>(3, 5));
  cout << "There are " << inrange << " numbers in the range 3 to 5" << endl;
  
  vector<string> names;
  
  string newname;
  cin >> newname;
  while(!cin.eof()){
    names.push_back(newname);
    cin >> newname;
  }

  inrange = count_if(names.begin(), names.end(), check_in_range<string>("c", "j"));
  cout << "There are " << inrange << " strings in the range c to j" << endl;
}
