//
//  stlsort.cpp
//  Program demonstrating the use of the STL sort algorithm,
//  both using its default ascending ordering, assuming < comparisons,
//  and by using function to specify how comparisons should be made
//
//  Clemson University  CPSC 1070
//  Created by Donald House on 12/3/19.
//

#include <iostream>
#include <string>
#include <vector>
#include <algorithm>
using namespace std;

template <class Type>
void printit(Type i){
  cout << i << " ";
}

template <class CType>
bool mygreater(CType v1, CType v2){
  return v1 > v2;
}

int main(){
  vector<int> table;
  
  int num;
  cin >> num;
  while(num >= 0){
    table.push_back(num);
    cin >> num;
  }
  
  // print the original table
  for_each(table.begin(), table.end(), printit<int>);
  cout << endl;

  // sort and print using the default comparison
  // sort will be in ascending order
  sort(table.begin(), table.end());
  for_each(table.begin(), table.end(), printit<int>);
  cout << endl;
      
  // sort and print using the defined comparison
  // sort will be in descending order
  sort(table.begin(), table.end(), mygreater<int>);
  for_each(table.begin(), table.end(), printit<int>);
  cout << endl;
}
