//
// filenumbers.c
// Generate the pairs of numbers needed to build addition or times tables
// With output sent to the file named on the command line
// Donald House
// 9/22/19
//
// CPSC 1070
// Clemson University
//
#include <stdio.h>

#define MAXNUMBER   12

int main(int argc, char *argv[]){
  int i, j;
  FILE *outfile;
  
  if(argc != 2){
    printf("usage: filenumbers <filename>\n");
    return 1;
  }
  
  outfile = fopen(argv[1], "w");
  if(outfile == NULL){
    printf("cannot open output file %s\n", argv[1]);
    return 2;
  }
  
  for(i = 1; i <= MAXNUMBER; i++)
    for(j = 1; j <= MAXNUMBER; j++)
      fprintf(outfile, "%d %d\n", i, j);
  
  fclose(outfile);
  
  return 0;
}
