//
// Template for an Array class
// Array.h header file
//
// Donald H. House  Nov. 23, 2019
// CPSC 1070 example code
// Clemson University
//

#include <iostream>
using namespace std;

template<class Type>
class Array;

template<class Type>
ostream& operator<<(ostream& os, const Array<Type> &a);

//
// Template for Class of 1D Array
//
template<class Type>
class Array{
protected:
  int loidx, hiidx;		       // number of entries in Array
  int size;
  Type *data;
  
  void CheckBounds(int idx) const;
  
public:
  Array(int ilow = 0, int ihi = 0);	  // default + initialize constructors
  Array(const Array &a);              // copy constructor

  virtual ~Array();                   // destructor, make sure array space deleted
  
  void SetBounds(int ilow, int ihi); // assign bounds of Array
  int Low() const {return loidx;}	   // accessor function for low bound
  int Hi() const {return hiidx;}     // accessor function for high bound

  const Array &operator=(const Array &a);
  
  const Type &operator[](int idx) const;

  Type &operator[](int idx);
  
  // define << operator as friend function to Array
  friend ostream& operator<< <Type>(ostream& os, const Array &a);
};

template<class Type>
void Array<Type>::CheckBounds(int idx) const{
  if(idx < loidx || idx > hiidx){
    cerr << "array index: " << idx << " out of bounds: " << "(" << loidx << ", " << hiidx << ")" << endl;
    exit(11);
  }
}

template<class Type>
Array<Type>::Array(int ilo, int ihi): loidx(0), hiidx(0), size(0), data(NULL){  // default + initialize constructors
  cout << "construct Array (" << ilo << ", " << ihi << ")" << endl;
  SetBounds(ilo, ihi);
}

template<class Type>
Array<Type>::Array(const Array &a): loidx(a.loidx), hiidx(a.hiidx), size(0), data(NULL){          // copy constructor
  cout << "copy construct Array (" << loidx << ", " << hiidx << ")" << endl;
  SetBounds(loidx, hiidx);
  for(int i = 0; i < size; i++)
    data[i] = a.data[i];
}

template<class Type>
Array<Type>::~Array(){
  cout << "delete Array (" << loidx << ", " << hiidx << ")" << endl;
  delete []data;
}

template<class Type>
void Array<Type>::SetBounds(int ilo, int ihi){     // assign dimensions to Array
  if(ilo > ihi){
    cerr << "array bounds impossible: " << "[" << ilo << ", " << ihi << "]";
    exit(10);
  }
  
  if((ihi - ilo + 1) != size){
    delete []data;
    size = ihi - ilo + 1;
    data = new Type[size];
  }
  
  for(int i = 0; i < size; i++)
    data[i] = 0.0;
  
  loidx = ilo;
  hiidx = ihi;
}

template<class Type>
const Array<Type> &Array<Type>::operator=(const Array<Type> &a){
  if(this == &a)
    return *this;
  
  SetBounds(a.loidx, a.hiidx);
  for(int i = 0; i < size; i++)
    data[i] = a.data[i];
  
  return *this;
}

template<class Type>
const Type &Array<Type>::operator[](int idx) const{
  CheckBounds(idx);
  return data[idx - loidx];
}

template<class Type>
Type &Array<Type>::operator[](int idx){
  CheckBounds(idx);
  return data[idx - loidx];
}

// define << operator as friend function to Array
template<class Type>
ostream& operator<<(std::ostream& os, const Array<Type> &a){
  os << "(" << a.loidx << ", " << a.hiidx << "):{";
  for(int i = 0; i < a.size - 1; i++)
    os << a.data[i] << ", ";
  os << a.data[a.size - 1] << "}";
  return os;
}
