//
// Queue.h
//
// list based C++ Queue class declaration
//
// CPSC 1070 example program
// Donald H. House, 10/15/2019
//

#include "Container.h"
#include <iostream>
using namespace std;

template<class Type>
class Queue{
private:
  Container<Type> *head, *tail;  // pointers to head and tail entry in queue
  int n;		// number of entries in the queue

public:
  Queue();		// default constructor, start with empty queue
  ~Queue();		// destructor, free space held by queue

  void Clear();        // initialize the queue to empty
  bool Empty() const;   // returns true if the queue is empty, false otherwise

  void Enter(Type newvalue);  // place a new value at the end of the queue
  Type Leave();				 // remove the head value in the queue
};

// constructor for Queue class
template<class Type>
Queue<Type>::Queue(): head(NULL), tail(NULL), n(0){
}

// destructor for Queue class
template<class Type>
Queue<Type>::~Queue(){
  Clear();
}

// initialize the queue to empty
template<class Type>
void Queue<Type>::Clear(){
  while(!Empty())
    Leave();
}

// return true if queue empty, false otherwise
template<class Type>
bool Queue<Type>::Empty() const{
  return head == NULL;
}

// insert a new value at the end of the queue
template<class Type>
void Queue<Type>::Enter(Type newvalue){
  Container<Type> *newentry = new Container<Type>(newvalue, NULL);
  
  if(tail == NULL)
    head = newentry;
  else
    tail->next = newentry;
  
  tail = newentry;
  n++;
}

// remove the head entry in the queue and return its value
template<class Type>
Type Queue<Type>::Leave(){
  if(Empty()){
    cerr << "Queue underflow." << endl;
    exit(2);
  }
  
  Type retvalue = head->data;
  Container<Type> *kill = head;
  
  head = head->next;
  if(head == NULL)
    tail = NULL;
  
  delete kill;
  
  n--;
  return retvalue;
}

