//
// Player.cpp
//
// Player class definition for maze game
// CPSC 1070
// Donald H. House, 10/21/2019
//

#include "Player.h"
#include "ezdraw.h"

#include <cmath>
#include <iostream>

using namespace std;

// constructor: start with Player at an impossible position
Player::Player(){
  row = col = -1;
}

// position the Player
void Player::SetPosition(int r, int c){
  row = r;
  col = c;
}

// get the Player position
void Player::GetPosition(int &r, int &c) const{
  r = row;
  c = col;
}

void Player::Move(DoorType d, const Room &room){
  if(room.IsDoor(d)){
    if(d == dleft)
      col--;
    else if(d == dright)
      col++;
    else if(d == ddown)
      row--;
    else if(d == dup)
      row++;
    else{
      cerr << "invalid door type: " << d << endl;
      exit(6);
    }
  }
}

// get the Player's row
int Player::Row() const{
  return row;
}

// get the Player's column
int Player::Col() const{
  return col;
}

void Player::SetSize(int size){
  roomsize = size;
}

void Player::SetTextureID(int texid){
  texture = texid;
}

// draw the Player
void Player::Draw() const{
  EZ_Rect playerrect;
  playerrect.x = col * roomsize;
  playerrect.y = row * roomsize;
  playerrect.w = playerrect.h = roomsize;

  EZ_DrawTexture(texture, NULL, &playerrect);
}
