//
// Room.cpp
//
// Room class definition for maze game
// CPSC 1070
// Donald H. House, 10/21/2019
//

#include "Room.h"
#include "ezdraw.h"

#include <iostream>
using namespace std;

//
// constructor: by default, room is a wall with no doors or texture
//
Room::Room(){
  type = WALL;
  texture = 0;
  
  for(int i = dleft; i <= dup; i++)
    doors[i] = false;
}

void Room::SetType(char ch){
  switch(ch){
      case 'w':
      type = WALL;
      break;
    case 's':
      type = START;
      break;
    case 'g':
      type = GOAL;
      break;
    case 'c':
      type = CORRIDOR;
      break;
    case 'h':
      type = HEALTH;
      break;
    case 'b':
      type = BOSS;
      break;
    default:
      cerr << "Illegal cell type: " << ch << endl;
  }
}

RoomType Room::Type() const{
  return type;
}

void Room::MakeDoor(int dx, int dy){
  if(dy == 0)
    doors[(dx + 1) / 2] = true;
  else
    doors[2 + (dy + 1) / 2] = true;
}

bool Room::IsDoor(DoorType d) const{
  return doors[d];
}

void Room::SetTextureID(int texarray[]){
  texture = texarray[type];
}

int Room::GetTextureID() const{
  return texture;
}

void Room::SetSize(int size){
  roomsize = size;
}

void Room::Draw(int row, int col) const{
  EZ_Rect roomrect;

  roomrect.x = col * roomsize;
  roomrect.y = row * roomsize;
  roomrect.w = roomrect.h = roomsize;
  EZ_DrawTexture(texture, NULL, &roomrect);
}
