//
// helloworld.c
//
// Simple program using EZ Draw to load an image from a BMP file and
// draw it to the screen, along with a cutout from the image
// for CPSC 1070, Fall 2019.
//
// Donald House, 10/8/19
// Clemson University
//
#include "ezdraw.h"
#include <stdio.h>

// dimensions of the display window
#define WINDOWWIDTH       800
#define WINDOWHEIGHT      600

// coordinates of the textures are relative to the window
#define RECTX0            (WINDOWWIDTH / 3)
#define RECTY0            (WINDOWHEIGHT / 3)
#define CUTOUTOFFSET      (WINDOWWIDTH / 3)
#define CUTOUTX0          100
#define CUTOUTY0          100
#define CUTOUTWIDTH       50
#define CUTOUTHEIGHT      50

// RGB colors for the screen background
// note: R, G, and B are on a scale from 0 to 255
#define BACKCOLOR         70, 100, 140

// handy boolean constants
//typedef enum _bool{FALSE, TRUE} bool;

EZ_Image *girl;       // girl image to be read from BMP file
int girltex;          // texture ID for the girl image

// display routine, called from EZ_HandleEvents every 1/30 of a second
void updateDisplay(){
  // output rectangle for the full girl texture
  EZ_Rect rect1 = {RECTX0, RECTY0, girl->w, girl->h};
  
  // rectangle for the cutout of the girl texture
  EZ_Rect rectt = {CUTOUTX0, CUTOUTY0, CUTOUTWIDTH, CUTOUTHEIGHT};

  // cutout display rectangle is the same size as texture cutout
  // but positioned on the screen
  EZ_Rect rectd;
  rectd = rectt;
  rectd.x = RECTX0 + CUTOUTOFFSET;
  rectd.y = RECTY0 + CUTOUTY0;

  EZ_SetBackColor(BACKCOLOR);   // specify background color for the drawing
  EZ_ClearDrawing();            // clear the drawing to the background color
  
  EZ_DrawTexture(girltex, NULL, &rect1);    // draw the full girl texture
  EZ_DrawTexture(girltex, &rectt, &rectd);  // draw cutout of the girl

  EZ_DisplayDrawing();          // send the new drawing to the screen
}

//
// main function that loads the girl image, starts EZ Draw,
// and creates a texture for the image. The event loop causes the
// updateDisplay() routine to be called every 1/30 of a second to
// draw the texture in the window
//
int main() {
  bool quit = false;

  girl = EZ_LoadBMPImage("girl.bmp");
  if(girl == NULL){
    fprintf(stderr, "invalid image\n");
    exit(1);
  }

  EZ_Init(WINDOWWIDTH, WINDOWHEIGHT, "Hello World with Girl Texture");

  girltex = EZ_CreateTexture(girl);

  while(!quit){
    quit = EZ_HandleEvents(updateDisplay, NULL, NULL, NULL);
  }
  
  EZ_Quit();

  return 0;
}
