//
//  reader.c
//
//  Created by Donald House on 9/30/19.
//  For CPSC 1070 Lab Project on 10/2/19
//  Clemson University
//

#include <stdio.h>
#include <string.h>
#include <ctype.h>

void removePunctuation(const char *str, char *cleanstr){
  int i, j;
  char ch;
  
  for(i = 0, j = 0; str[i] != '\0'; i++){
    ch = tolower(str[i]);
    if(isalpha(ch))
      cleanstr[j++] = ch;
  }
  cleanstr[j] = '\0';
}

int main(int argc, char *argv[]){
  FILE *infile;
  char instring[1000];
  char cleanstring[1000];

  if(argc != 2){
    printf("usage: reader <filename>\n");
    return 1;
  }
  
  infile = fopen(argv[1], "r");
  if(infile == NULL){
    printf("cannot open file %s\n", argv[1]);
    return 2;
  }
  
  while(fscanf(infile, "%s", instring) == 1){
    removePunctuation(instring, cleanstring);
    printf("%s\n", cleanstring);
  }
  
  return 0;
}
