//
// Grid.h
//
// Grid class declaration for 3x3 grid
// CPSC 1070
// Donald H. House, 10/21/2019
//

#ifndef _GRID_H
#define _GRID_H

#include "ezdraw.h"

class Grid{
private:
  // arrays to hold pointers to the images, and the texture ID's
  EZ_Image *images[2];
  int textures[2];
  int cellsize;
  
public:
  Grid();         // constructor, load grid from disk file
  ~Grid();        // destructor, clean up textures
    
  void Load(const char *gridfilename);
  void MakeTextures();
    
  void SetCellSize(int pixels);
  int GetCellSize() const;
  
  void Draw() const;
};

#endif
