//
// Sample C++ solution to the Lab on 10/28 to display a checkerboard grid
// using textures whose image file names are read from a file
//
// CPSC 1070
// Donald H. House, 10/21/2019
// Clemson University
//

#include "ezdraw.h"
#include "Grid.h"

#include <cstdlib>
#include <iostream>

using namespace std;

// Maximum width of the display window
#define WINDOWWIDTH    600
#define NUMBEROFCELLS   3

Grid TheGrid;

//
// Display Routine: clear the screen and draw the maze overview
// and the player
//
void updateDisplay(){
  // clear the window to the background color
  EZ_ClearDrawing();

  TheGrid.Draw();

  EZ_DisplayDrawing();
}

//
// main function that loads the images, starts EZ Draw,
// and creates texture for the images.
//
int main(int argc, char *argv[]) {
  if(argc != 2){
    cerr << "usage: makegrid <gridfilename>" << endl;
    exit(1);
  }
  
  TheGrid.Load(argv[1]);
  
  // open the EZ Draw window with size proportional to the grid size
  TheGrid.SetCellSize(WINDOWWIDTH / NUMBEROFCELLS);
  EZ_Init(WINDOWWIDTH, WINDOWWIDTH, "3 x 3 Grid");
    
  TheGrid.MakeTextures();
  
  // event loop to drive the display at 30 updates per second,
  // and to respond to keyboard presses to move the character
  bool quit = false;
  while(!quit){
    quit = EZ_HandleEvents(updateDisplay, NULL, NULL, NULL);
  }
  
  EZ_Quit();

  return 0;
}

