/*
 broccoli.cpp
 EZ Draw Program to Draw a Broccoli Tree. A recursion demonstration
 
 CPSC 1070         Donald H. House         2/2/2019
 Clemson University
*/

#include <stdio.h>	/* definitions for standard I/O routines */
#include <math.h>	  /* definitions for math routines */

#include "ezdraw.h"

#define PI            3.1415926536

// Window Dimensions
#define WIDTH	        800
#define HEIGHT		    600

#define X0			      (WIDTH / 2)
#define Y0			      (HEIGHT / 20)
#define LENGTH		    (HEIGHT / 3)
#define MINLENGTH	    (LENGTH / 80)
#define LENGTHRATIO   0.60
#define BRANCHANGLE   30.0

#define BACKCOLOR     0, 0, 0
#define BROCCOLICOLOR 51, 179, 51

/*
 Routine to recursively draw a broccoli
*/
void drawBroccoli(float x0, float y0, float length, float angle){
  float theta = PI / 2.0 + PI * (angle / 180.0);
  float x1, y1;
  
  if(length < MINLENGTH)
    EZ_OutlineCircle(x0, y0, length);
  else{
    x1 = x0 + length * cos(theta);
    y1 = y0 + length * sin(theta);
    EZ_DrawLine(x0, y0, x1, y1);
    
    drawBroccoli(x1, y1, length * LENGTHRATIO, angle + BRANCHANGLE);
    drawBroccoli(x1, y1, length * LENGTHRATIO, angle - BRANCHANGLE);
  }
}

/*
 Display callback routine: clear the screen and draw the broccoli
 This is called every 1/30 of a second
*/
void drawDisplay(){
  
  /* clear the drawing to the background color */
  EZ_SetBackColor(BACKCOLOR);
  EZ_ClearDrawing();
  
  /* draw the broccoli tree */
  EZ_SetColor(BROCCOLICOLOR);
  drawBroccoli(X0, Y0, LENGTH, 0);
  
  EZ_DisplayDrawing();
}

/*
  Main program to draw a broccoli and then wait for quit
*/
int main(){
  bool quit = false;
  
  /* start up the glut utilities */
  EZ_Init(WIDTH, HEIGHT, "Broccoli Tree Demonstration");
  
  while(!quit){
    quit = EZ_HandleEvents(drawDisplay, NULL, NULL, NULL);
  }
  
  EZ_Quit();
  return 0;
}
