//
// trysort.cpp
//
// program to demonstrate a templated sort routine
//
// CPSC 1070 lab exercise program for 11/25
// Donald H. House, 11/24/2019
//
#include <iostream>
#include <cmath>
#include <fstream>
#include "Sort.h"

using namespace std;

#define MAXNUMS 1000

// 2D vector class with > overloaded according to L1 norm
// L1 norm measures distance according to the Manhattan Metric
// That is, the vector's length is the sum of the magnitudes of its components
struct VectorL1{
  float x, y;
  bool operator>(const VectorL1 &p){
    return (fabs(x) + fabs(y)) > (fabs(p.x) + fabs(p.y));
  }
};

// 2D vector class with > overloaded according to L2 norm
// L2 norm measures distance according to the Euclidian Metric
// That is, the vector's length is the square root of the sum of the squares
// of its components
struct VectorL2{
  float x, y;
  bool operator>(const VectorL2 &p){
    return (x * x + y * y) > (p.x * p.x + p.y * p.y);
  }
};

// 2D vector class with > overloaded according to L infinity norm
// L infinity norm measures distance according to the Max Metric
// That is, the vector's length is the magnitude of its largest component
struct VectorLInf{
  float x, y;
  bool operator>(const VectorLInf &p){
    float max = fabs(x) > fabs(y)? fabs(x): fabs(y);     // ternary comparison operator (look it up)
    float pmax = fabs(p.x) > fabs(p.y)? fabs(p.x): fabs(p.y);
    return max > pmax;
  }
};

int main(int argc, char *argv[]){
  float num, numbers[MAXNUMS];
  int n;
  int len;
  
  if(argc != 2){
    cerr << "usage: trysort <datafile>" << endl;
    return 1;
  }
  
  ifstream infile;
  infile.open(argv[1]);
  if(!infile.is_open()){
    cerr << "error opening data file " << argv[1] << endl;;
    return 2;
  }
  
  infile >> num;
  for(n = 0; n < MAXNUMS && !infile.eof(); n++){
    numbers[n] = num;
    infile >> num;
  }
  
  len = n / 2;
  VectorL1 list1[len];
  VectorL2 list2[len];
  VectorLInf list3[len];
  
  for(int i = 0; i < n; i += 2){
    list1[i / 2].x = numbers[i];
    list1[i / 2].y = numbers[i + 1];
    
    list2[i / 2].x = numbers[i];
    list2[i / 2].y = numbers[i + 1];
    
    list3[i / 2].x = numbers[i];
    list3[i / 2].y = numbers[i + 1];
  }
 
  cout << "unsorted: " << endl;
  for(int i = 0; i < len; i++)
    cout << "(" << list1[i].x << ", " << list1[i].y << ")" << endl;
  cout << endl;

  cout << "sorted, L1: " << endl;
  Sort(list1, len);
  for(int i = 0; i < len; i++)
    cout << "(" << list1[i].x << ", " << list1[i].y << ")" << endl;
  cout << endl;
  
  cout << "sorted, L2: " << endl;
  Sort(list2, len);
  for(int i = 0; i < len; i++)
    cout << "(" << list2[i].x << ", " << list2[i].y << ")" << endl;
  cout << endl;

  cout << "sorted, L3: " << endl;
  Sort(list3, len);
  for(int i = 0; i < len; i++)
    cout << "(" << list3[i].x << ", " << list3[i].y << ")" << endl;

  return 0;
}
